<?php
/*
Plugin Name: Folding Pages Widget
Plugin URI: http://navyroad.com/wordpress-plugins/nrs-folding-pages-widget/
Description: Provides a hierarchical list of pages for your sidebar.
Author: Chris Carson
Version: 1.0
Author URI: http://navyroad.com
Credits: Thanks to Andy Skelton.  Based on code by Erwin Harte (http://is-here.com/projects/wordpress/pages) Calvin Yu (http://blog.codeeg.com/)
*/

function nrs_folding_pages($args){
    extract($args);
    //var_dump($args);
    $sort_opts = nrs_folding_pages_get_sort_opts();
    $options = get_option("nrs_folding_pages");
    $title = (empty($options["title"])) ? null : $options["title"];
	$sort_column = (array_key_exists($options["sort_column"],$sort_opts)) ? $options["sort_column"] : key($sort_opts);
	
    global $notfound;
	global $post;
	
	//returns a numerically indexed array...
	$pages = get_pages("sort_column=$sort_column");
	//a new associative array indexed by ID... 
	$nodes = array();
	foreach ($pages as $page) $nodes[$page->ID] = $page;
	//an array to hold the parent ids in the current tree...
	$parent_ids = array();
	if (is_page() and ($notfound != '1')) 
	{
		$curr_page_id = $post->ID;
		while ($curr_page_id)
		{
			array_unshift($parent_ids, $curr_page_id );
			$curr_page_id = $nodes[$curr_page_id]->post_parent;
		}
	}
	//add the top-level parent id, which is 0...
	array_unshift($parent_ids, 0 );
	
	//output...
	echo $before_widget;
	echo  $before_title . $title . $after_title;
	nrs_display_tree($parent_ids, $nodes, 0);
	echo $after_widget;
}
function nrs_display_tree($parent_ids, $nodes, $curr_id)
{
	global $post;
	if ($curr_id)
	{
		$node = $nodes[$curr_id];
		$title = wp_specialchars($node->post_title);
		$link = get_page_link($curr_id);
		$class = "page_item";
		if ($curr_id == $post->ID) $class .= " current_page_item";
		echo "<li class=\"$class\"><a href=\"$link\" title=\"$title\">$node->post_title</a>";
	}
	if (in_array($curr_id, $parent_ids)) 
	{
		$num_children = 0;
		foreach ($nodes as $node)
		{
			if ($node->post_parent == $curr_id) 
			{
				if (! $num_children) echo "\n<ul>";
				nrs_display_tree($parent_ids, $nodes, $node->ID);
				$num_children++;
			}
		}
		if ($num_children) echo "</ul>\n";
		
	}
	if ($curr_id) echo "</li>\n";
	
}


function nrs_folding_pages_get_sort_opts() {
	return array( "post_title"=>"Title",
					"menu_order"=>"Page Order");
}
function nrs_folding_pages_control() {
	$sort_opts = nrs_folding_pages_get_sort_opts();
    $options = get_option("nrs_folding_pages");
   
    if ( $_POST['nrs_folding_pages_submit'] ) 
    {
		$options['title'] = strip_tags(stripslashes($_POST['nrs_folding_pages_title']));
		$options['sort_column'] = (array_key_exists($_POST['nrs_folding_pages_sort_column'], $sort_opts)) ? $_POST['nrs_folding_pages_sort_column'] : key($sort_opts);
		update_option('nrs_folding_pages', $options);
    }
    $sort_column = (array_key_exists($options["sort_column"],$sort_opts)) ? $options["sort_column"] : key($sort_opts);
    $title = wp_specialchars($options['title']);

?>
	<input type="hidden" id="nrs_folding_pages_submit" name="nrs_folding_pages_submit" value="1" />
	<p><label for="nrs_folding_pages_title"><?php _e('Title:'); ?> <input style="width: 250px;" id="nrs_folding_pages_title" name="nrs_folding_pages_title" type="text" value="<?php echo $title; ?>" /></label></p>
	<p><label for="nrs_folding_pages_sort_column">
		<?php _e('Sort:'); ?> 
		<select  id="nrs_folding_pages_sort_column" name="nrs_folding_pages_sort_column">
		<?php
		foreach ($sort_opts as $val=>$label){
			echo "<option value=\"$val\"";
			if ($sort_column == $val) echo " selected";
			echo ">$label</option>";
		}
		?>
		</select>
	</label></p>
	
<?php
}
function nrs_folding_pages_init()
{

    register_sidebar_widget("NRS Folding Pages", "nrs_folding_pages");
    register_widget_control("NRS Folding Pages", "nrs_folding_pages_control");
}

add_action("plugins_loaded", "nrs_folding_pages_init");

?>